﻿// See https://aka.ms/new-console-template for more information

Console.BackgroundColor = ConsoleColor.Black;
Console.ForegroundColor = ConsoleColor.Blue;

PasswordValidator newPassWord = new PasswordValidator();

while (true)
{
    Console.WriteLine("Make a password:");
    string? password = Console.ReadLine();
    if (password == null)
        break;
    
    if (newPassWord.isAllowed(password)) Console.WriteLine("Valid password");
    else Console.WriteLine("Invalid password");
    
}

    

public class PasswordValidator
{
    public bool isAllowed(string password)
    {
        if (password.Length < 6) return false;
        if (password.Length > 13) return false;
        if (!HasUppercase(password)) return false;
        if (!HasLowercase(password)) return false;
        if (!HasDigits(password)) return false;
        if (Contains(password, 'T')) return false;
        if (Contains(password, '&')) return false;

        return true;
    }

    private bool HasUppercase(string password)
    {
        foreach (char letter in password)
            if (char.IsUpper(letter)) return true;

        return false;
    }

    private bool HasLowercase(string password)
    {
        foreach (char letter in password)
            if (char.IsLower(letter)) return true;
        
        return false;
    }

    private bool HasDigits(string password)
    {
        foreach (char digit in password)
            if (char.IsDigit(digit)) return true;
        
        return false;
    }

    private bool Contains(string password, char letter)
    {
        foreach (char character in password)
            if (character == letter) return true;
        
        return false;
    }
    
}
